## Backend e Banco de Dados (v1.0.9 → v2.0.0)

### Stack e Dependências
- Servidor: `Node.js` + `Express` com `cors`, `dotenv`, `jsonwebtoken`, `bcryptjs`, `multer`.
- Banco: `MySQL` via `mysql2/promise` em runtime; `Sequelize` + `sequelize-cli` para migrations/seeders.
- Pastas principais: `server/src` (código do servidor), `server/migrations` e `server/seeders`, `server/uploads` (arquivos de imagem).

### Ambiente
- Variáveis em `server/.env.example`:
  - `DB_HOST`, `DB_PORT`, `DB_USER`, `DB_PASSWORD`, `DB_NAME`.
  - `PORT` (padrão `4000`), `JWT_SECRET` (defina uma chave forte).
- Configure `.env` antes de iniciar o servidor.

### Configuração do Sequelize CLI
- Arquivo: `server/config/config.cjs` (dialeto `mysql`, ambiente `development`).
- Comandos:
  - `npm run db:migrate` — aplica migrations.
  - `npm run db:migrate:undo` — desfaz última migration.
  - `npm run db:seed` — aplica seeders.
  - `npm run db:seed:undo` — desfaz seeders.

### Migrations
- `20251002-0001-create-fornecedores.cjs` — tabela `fornecedores` (`id`, `nome`).
- `20251002-0002-create-notas-fiscais.cjs` — tabela `notas_fiscais` (campos principais de NF + `fornecedor_id`).
- `20251002-0003-create-nf-history.cjs` — tabela `nf_history` (status histórico por NF).
- `20251002-0004-create-grds.cjs` — tabela `grds` (emissão e observação).
- `20251002-0005-create-grd-nf.cjs` — tabela pivô `grd_nf` (associação GRD↔NF).
- `20251002-0006-create-users.cjs` — tabela `users` (`id`, `nome`, `email`, `role`, `password_hash`, timestamps).
- `20251002-0007-add-photo-url-to-users.cjs` — adiciona `photo_url` em `users`.

### Seeders
- `20251002-0001-seed-users.cjs` — cria usuários padrão:
  - Master: `master@myapp.local` / senha `Master@123`.
  - Diligenciador: `diligenciador@myapp.local` / senha `Diligencia@123`.
  - Almoxarife: `almoxarife@myapp.local` / senha `Almoxarife@123`.
  - Conferente: `conferente@myapp.local` / senha `Conferente@123`.
- Observação: altere senhas e e-mails no ambiente de produção.

### Uploads e Arquivos Estáticos
- Diretório: `server/uploads` (criado automaticamente).
- Rota estática: `GET /uploads/...` — arquivos servidos diretamente.
- Upload de foto: `POST /api/users/me/photo` (autenticado) com `multipart/form-data`:
  - Campo: `photo` (tipos permitidos: `.jpg`, `.jpeg`, `.png`, `.gif`, `.webp`, até 5MB).
  - Resposta: `{ photo_url: '/uploads/<arquivo>' }`.

### Autenticação
- Login: `POST /api/auth/login` com `{ email, password }`.
- Resposta: `{ token, user }`.
- Autorização: enviar `Authorization: Bearer <token>` nas rotas protegidas.
- Middleware valida `JWT_SECRET` e popula `req.user` com `{ sub, role }`.

### Endpoints Principais
- `GET /api/health` — verificação de saúde do servidor.
- Usuários:
  - `POST /api/users` (Master) — cria usuários; corpo `{ nome, email, role, password }`.
  - `GET /api/users/me` — dados do usuário autenticado.
  - `PUT /api/users/me` — atualiza `nome` e/ou `email` (verifica duplicidade).
  - `POST /api/users/me/password` — troca de senha com `{ currentPassword, newPassword }`.
  - `POST /api/users/me/photo` — upload de foto (ver acima).
- Fornecedores:
  - `GET /api/fornecedores` — lista fornecedores.
  - `POST /api/fornecedores` — cria fornecedor `{ nome }` (uppercase).
  - `PUT /api/fornecedores/:id` — atualiza nome.
  - `DELETE /api/fornecedores/:id` — remove fornecedor.
- Notas Fiscais:
  - `GET /api/nfs` — lista NFs com `fornecedor_nome` (join).
  - `POST /api/nfs` — cria NF com upsert de fornecedor; corpo `{ numeroNF, numeroPedido, fornecedor, dataPrevisao, dataEmissao, numeroCTE?, observacao? }` e status inicial `Pendente` com histórico.

### Execução do Backend
- `cd server && npm start` — inicia servidor em `http://localhost:${PORT}`.
- Pré-requisito: banco MySQL acessível e `.env` configurado.

### Observações de Compatibilidade Frontend
- `vite.config.ts` tem proxy de `/uploads` → backend, garantindo exibição de avatar.
- Frontend usa `getMe` para sincronizar `photo_url`, refletindo mudanças após upload.


# Versão v2.0.0

## Visão Geral
- Integração de avatar do usuário no cabeçalho com menu retrátil.
- Edição de perfil via modal centralizado acionado pelo cabeçalho.
- Correção do upload de foto de perfil com `FormData` e proxy de `/uploads`.
- Ajustes de UX no cabeçalho (ordem texto→avatar, tamanho do avatar).
- Correção de erro de hooks no `App.tsx` (Invalid hook call).

## Mudanças de Frontend
- `components/Header.tsx`
  - Substitui o ícone por avatar quando `photo_url` está disponível.
  - Exibe `nome` e `role` do usuário ao lado do avatar.
  - Torna o avatar um menu retrátil com ações: `Editar perfil` e `Sair da Aplicação`.
  - Ajusta tamanho do avatar para `w-10 h-10` e posiciona após nome/função.
- `App.tsx`
  - Sincroniza usuário atual com backend via `getMe` (inclui `photo_url`).
  - Move `handleLogout` para dentro do componente e passa `onLogout` ao `Header`.
  - Abre modal de perfil ao acionar `onOpenProfile` no cabeçalho.
- `components/Dashboard.tsx`
  - Remove o `ProfilePanel` embutido; edição de perfil migra para modal no `App`.
- `types.ts`
  - Estende `User` com `email?` e `photo_url?` para suportar avatar e dados.

## Upload de Foto de Perfil
- `services/http.ts`
  - Ajusta a função de requisições para não forçar `Content-Type: application/json` ao enviar `FormData`.
- `services/users.ts`
  - Atualiza `uploadPhoto` para enviar `FormData` diretamente (browser define o `Content-Type`).
- `vite.config.ts`
  - Configura proxy para `/uploads` apontando para o backend, permitindo servir imagens de perfil corretamente em desenvolvimento.

## Correções de Bugs
- Resolve `Invalid hook call` e `TypeError: Cannot read properties of null (reading 'useCallback')` movendo `handleLogout` para dentro do `App`.

## Execução
- Backend: `npm start` em `server/` (padrão em `http://localhost:4000`).
- Frontend: `npm run dev` no projeto raiz.
  - Se a porta `3000/3001/3002` estiver em uso, o dev server escolhe a próxima disponível (ex.: `3003`).

## Testes Manuais
- Cabeçalho: verificar nome, função e avatar visíveis; clicar no avatar abre menu.
- Menu: acionar `Editar perfil` para abrir modal e `Sair da Aplicação` para logout.
- Upload: no modal de perfil, selecionar imagem e confirmar; avatar deve atualizar.


# Versão v2.0.1

## Visão Geral
- Correção: falha ao gerar GRD no backend resolvida.
- Ajuste de schema: tabela `grds` padronizada para coluna `codigo` (string única), eliminando divergências com `numero_grd` em bancos legados.
- Nova migration: `server/migrations/20251002-0008-fix-grds-schema.cjs`.

## Como atualizar
- Aplique migrations no backend:
  - `cd server`
  - `npm run db:migrate`
- Reinicie o servidor: `npm start`.

## Impacto no Frontend
- Footer atualizado para exibir `Versão da aplicação: v2.0.1`.
- Fluxo de criação/listagem de GRD permanece o mesmo; o backend agora retorna corretamente `codigo` e `nf_ids`.


# Versão v2.0.2

## Preparação para Produção (cPanel)
- Adicionado bloco `production` no `server/config/config.cjs` para uso do Sequelize CLI com variáveis de ambiente.
- Criado arquivo `server/.env.production` (exemplo) contendo `DB_HOST`, `DB_PORT`, `DB_USER`, `DB_PASSWORD`, `DB_NAME`, `PORT` e `JWT_SECRET`.
- Documentados passos de deploy no cPanel:
  1. Criar App Node.js apontando para `server/src/index.js`.
  2. Definir variáveis de ambiente (`DB_*`, `JWT_SECRET`) no painel.
  3. Instalar dependências e aplicar migrations/seeders:
     - `cd server && NODE_ENV=production npx sequelize-cli db:migrate --config config/config.cjs`
     - `NODE_ENV=production npx sequelize-cli db:seed:all --config config/config.cjs`
  4. Reiniciar a aplicação Node.
  5. Frontend: executar `npm run build` e publicar o conteúdo de `dist/` em `public_html`.

## Observações
- Em produção, certifique-se de que todas as migrations relacionadas a GRD estejam aplicadas (`20251002-0004-create-grds.cjs`, `20251002-0005-create-grd-nf.cjs` e `20251002-0008-fix-grds-schema.cjs`).
- O frontend chama a API via caminho relativo `/api/...`; no cPanel, mantenha o mesmo domínio para backend e frontend (o Passenger roteia para o app Node). Caso utilize subdomínio diferente, configure um proxy reverso ou ajuste a base URL no frontend.
