import { request } from './http';

export async function getNFs() {
  return request('/api/nfs');
}

export type CreateNFInput = {
  numeroNF: string;
  numeroPedido: string;
  fornecedor: string; // nome do fornecedor
  dataPrevisao: string; // YYYY-MM-DD
  dataEmissao: string; // YYYY-MM-DD
  numeroCTE?: string;
  observacao?: string;
};

export async function createNF(payload: CreateNFInput) {
  return request('/api/nfs', {
    method: 'POST',
    body: JSON.stringify(payload),
  });
}