import { request } from './http';

export type GrdResponse = {
  id: string;
  codigo: string; // número do GRD como string
  data_emissao: string; // ISO/DATETIME
  observacao?: string | null;
  nf_ids: string[];
};

export async function getGrds(): Promise<GrdResponse[]> {
  return request('/api/grds');
}

export async function createGrd(payload: { nfIds: string[]; observacao?: string }): Promise<GrdResponse> {
  return request('/api/grds', {
    method: 'POST',
    body: JSON.stringify(payload),
  });
}