'use strict';

module.exports = {
  async up(queryInterface, Sequelize) {
    await queryInterface.sequelize.query(`
      CREATE TABLE IF NOT EXISTS nf_history (
        id INT AUTO_INCREMENT PRIMARY KEY,
        nf_id VARCHAR(36) NOT NULL,
        status VARCHAR(50) NOT NULL,
        date DATETIME NOT NULL,
        user VARCHAR(50) NOT NULL,
        comentario TEXT,
        CONSTRAINT fk_history_nf FOREIGN KEY (nf_id) REFERENCES notas_fiscais(id) ON DELETE CASCADE
      ) ENGINE=InnoDB;
    `);
  },
  async down(queryInterface, Sequelize) {
    await queryInterface.sequelize.query('DROP TABLE IF EXISTS nf_history;');
  }
};