'use strict';

module.exports = {
  async up(queryInterface, Sequelize) {
    await queryInterface.sequelize.query(`
      CREATE TABLE IF NOT EXISTS notas_fiscais (
        id VARCHAR(36) PRIMARY KEY,
        numero_nf VARCHAR(50) NOT NULL,
        numero_pedido VARCHAR(50) NOT NULL,
        fornecedor_id VARCHAR(36) NOT NULL,
        data_previsao DATE NOT NULL,
        data_emissao DATE NOT NULL,
        numero_cte VARCHAR(50),
        observacao TEXT,
        status VARCHAR(50) NOT NULL,
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        CONSTRAINT fk_nf_fornecedor FOREIGN KEY (fornecedor_id) REFERENCES fornecedores(id) ON DELETE CASCADE
      ) ENGINE=InnoDB;
    `);
  },
  async down(queryInterface, Sequelize) {
    await queryInterface.sequelize.query('DROP TABLE IF EXISTS notas_fiscais;');
  }
};