# Guia de Instalação no cPanel (v2.0.2)

Este guia descreve, passo a passo, como publicar o backend (Node.js/Express + MySQL) e o frontend (Vite/React) no cPanel utilizando o Passenger (Setup Node.js App).

## Visão Geral
- Backend roda como aplicação Node.js (Passenger) apontando para `server/src/index.js`.
- Frontend é estático: gere com `npm run build` e publique o conteúdo de `dist/` em `public_html`.
- Banco MySQL: utilize as credenciais fornecidas e aplique as migrations/seeders com `NODE_ENV=production`.

## Pré‑requisitos
- Acesso ao cPanel com permissão para criar App Node.js.
- Banco MySQL criado com usuário e privilégios (SELECT/INSERT/UPDATE/DELETE/CREATE/ALTER).
- Node.js 18+ disponível no cPanel (Passenger).

## Passo a passo

1) Criar a aplicação Node.js (Passenger)
- Abra “Setup Node.js App” no cPanel.
- Clique em “Create Application”.
- Defina:
  - `Application Root`: caminho do projeto (ex.: `my-gestaodeentrega` ou onde o código foi enviado).
  - `Application Startup File`: `server/src/index.js`.
  - `Node.js version`: 18.x (ou superior disponível).
- Salve a aplicação.

2) Configurar variáveis de ambiente
- Ainda na tela da aplicação Node.js, adicione estas variáveis:
  - `DB_HOST`
  - `DB_PORT` (ex.: `3306`)
  - `DB_USER`
  - `DB_PASSWORD`
  - `DB_NAME`
  - `JWT_SECRET` (defina uma chave forte única para produção)
  - `PORT` (ex.: `4000`; o Passenger faz o roteamento pelo domínio, a porta é interna)
- Opcionalmente, você pode subir o arquivo `server/.env.production` com esses valores, porém no cPanel é recomendado usar variáveis de ambiente da aplicação.

3) Instalar dependências
- No card da aplicação Node.js, use “NPM Install” (se disponível) ou o Terminal do cPanel:
  - Backend: `cd server && npm install`
  - Raiz (frontend): `cd .. && npm install`

4) Executar migrations e seeders (produção)
- Abra o Terminal do cPanel e execute:
```
cd server
NODE_ENV=production npx sequelize-cli db:migrate --config config/config.cjs
NODE_ENV=production npx sequelize-cli db:seed:all --config config/config.cjs
```
- Confirme se as tabelas foram criadas (especialmente `users`, `fornecedores`, `notas_fiscais`, `nf_history`, `grds`, `grd_nf`).
- Garanta que a migration `20251002-0008-fix-grds-schema.cjs` está aplicada (alinha a tabela `grds` para usar `codigo`).

5) Reiniciar a aplicação Node
- No card da aplicação, clique em “Restart App” para subir o backend com as novas dependências e variáveis.

6) Build do frontend e publicação
- No Terminal do cPanel, na raiz do projeto:
```
npm run build
```
- Publique o conteúdo da pasta `dist/` em `public_html` (via Gerenciador de Arquivos ou `cp`/`rsync`).
- Se backend e frontend estiverem no mesmo domínio, as chamadas `/api/...` funcionarão automaticamente.
- Se usar subdomínio diferente para o backend (ex.: `api.seudominio.com`), ajuste a base de API no frontend (ou configure proxy reverso para manter `/api` no mesmo domínio).

7) Verificações pós‑deploy
- Acesse o frontend pelo domínio e faça login.
- Gere uma NF de teste (ou use seeders) e verifique listagem.
- No modal “Gerar GRD”, selecione NFs com status `CONFERIDO` e confirme a emissão.
- Verifique se o GRD aparece na listagem e no detalhamento.

## Troubleshooting
- Erro ao gerar GRD:
  - Cheque se as migrations foram aplicadas (tabelas `grds` e `grd_nf` presentes).
  - Confirme que os `nfIds` selecionados existem no banco (o backend valida IDs e retorna 400 se faltarem).
  - Veja logs no card da aplicação Node (Passenger) para mensagens `POST /api/grds error: ...`.
- Conexão MySQL:
  - Verifique usuário, senha e privilégios no cPanel MySQL.
  - Cheque `DB_HOST` e firewall de saída.
- Autenticação:
  - Em produção, altere `JWT_SECRET` e credenciais padrão criadas pelos seeders.
- Assets de perfil (`/uploads`):
  - O backend serve estático; em produção, mantenha os arquivos acessíveis e permissões corretas.

## Checklist de Produção
- [ ] Variáveis de ambiente definidas (`DB_*`, `JWT_SECRET`, `PORT`).
- [ ] `npm install` concluído em `server/` e na raiz.
- [ ] Migrations/seeders aplicados com `NODE_ENV=production`.
- [ ] Aplicação Node reiniciada (Passenger).
- [ ] `npm run build` executado; `dist/` publicado em `public_html`.
- [ ] Teste funcional: login, listagem de NFs, geração e visualização de GRD.

## Operações úteis
- Desfazer última migration:
```
cd server
NODE_ENV=production npx sequelize-cli db:migrate:undo --config config/config.cjs
```
- Refazer seeders:
```
cd server
NODE_ENV=production npx sequelize-cli db:seed:undo --config config/config.cjs
NODE_ENV=production npx sequelize-cli db:seed:all --config config/config.cjs
```

## Segurança
- Altere senhas padrão geradas pelos seeders e o `JWT_SECRET`.
- Restrinja acesso ao banco para o host do cPanel e seu app.
- Mantenha suas dependências atualizadas e aplique patches de segurança.