import React, { useState } from 'react';

interface ConfirmRecebimentoModalProps {
  onConfirm: (volumes: number) => void;
  onClose: () => void;
}

const ConfirmRecebimentoModal: React.FC<ConfirmRecebimentoModalProps> = ({ onConfirm, onClose }) => {
  const [volumes, setVolumes] = useState('');
  const [error, setError] = useState('');

  const handleSubmit = (e: React.FormEvent) => {
    e.preventDefault();
    const numVolumes = parseInt(volumes, 10);
    if (isNaN(numVolumes) || numVolumes <= 0) {
      setError('Por favor, informe um número de volumes válido.');
      return;
    }
    setError('');
    onConfirm(numVolumes);
  };

  return (
    <div className="fixed inset-0 bg-black/60 backdrop-blur-sm flex items-center justify-center z-50 p-4">
      <div className="bg-primary-dark border border-primary-medium rounded-2xl shadow-2xl shadow-primary-light/10 w-full max-w-md p-6 sm:p-8 transform transition-all duration-300 scale-95 animate-fade-in-up">
        <div className="flex justify-between items-center mb-6">
          <h2 className="text-2xl font-bold text-white">Confirmar Recebimento</h2>
          <button onClick={onClose} className="text-gray-400 hover:text-white transition-colors text-3xl font-light">&times;</button>
        </div>
        <form onSubmit={handleSubmit} className="space-y-4">
          <div>
            <label htmlFor="volumes" className="block text-sm font-medium text-gray-300 mb-1">
              Quantidade de Volumes Recebidos *
            </label>
            <input
              type="number"
              id="volumes"
              name="volumes"
              value={volumes}
              onChange={(e) => setVolumes(e.target.value)}
              min="1"
              className="w-full bg-primary-dark/50 border border-primary-medium rounded-lg px-3 py-2 text-white focus:ring-2 focus:ring-primary-light focus:border-primary-light transition"
              autoFocus
            />
            {error && <p className="text-red-400 text-sm mt-2">{error}</p>}
          </div>
          <div className="flex justify-end pt-4 space-x-3">
            <button type="button" onClick={onClose} className="px-6 py-2 rounded-full text-white bg-gray-600 hover:bg-gray-500 transition-colors">
              Cancelar
            </button>
            <button type="submit" className="px-6 py-2 rounded-full font-semibold text-primary-dark bg-primary-light hover:bg-opacity-90 transition-colors shadow-md shadow-primary-light/20">
              Confirmar
            </button>
          </div>
        </form>
      </div>
    </div>
  );
};

export default ConfirmRecebimentoModal;
