<div align="center">
<img width="1200" height="475" alt="GHBanner" src="https://github.com/user-attachments/assets/0aa67016-6eaf-458a-adb2-6e31a0763ed6" />
</div>

# MY — Gestão de Entrega

Aplicação para gestão e controle de Lead TIME no processo de diligenciamento, desde a emissão da NF até a conferência no almoxarifado.

## Executar Localmente

**Pré-requisitos:** Node.js 18+ e MySQL acessível.

1. Instale dependências (frontend e backend):
   - `npm install`
2. Configure o backend:
   - Copie `server/.env.example` para `server/.env` e ajuste `DB_*`, `PORT` e `JWT_SECRET`.
   - Aplique migrations e seeders:
     - `cd server`
     - `npm run db:migrate`
     - `npm run db:seed`
3. Inicie os servidores:
   - Backend: `cd server && npm start` (http://localhost:4000)
   - Frontend: `npm run dev` (http://localhost:3000)

## Notas de Versão

Consulte `version.md` para o histórico completo de mudanças.

### v2.0.2
- Preparação para produção (cPanel):
  - Adicionado `server/.env.production` com variáveis do MySQL.
  - Configuração `production` no `server/config/config.cjs` para migrations/seeders.
  - Passos de deploy:
    1) Criar app Node.js no cPanel com startup em `server/src/index.js`.
    2) Definir variáveis de ambiente (`DB_*`, `JWT_SECRET`).
    3) Instalar dependências e executar:
       - `cd server && NODE_ENV=production npx sequelize-cli db:migrate --config config/config.cjs`
       - `NODE_ENV=production npx sequelize-cli db:seed:all --config config/config.cjs`
    4) Reiniciar a aplicação Node.
    5) Frontend: `npm run build` e publicar `dist/` em `public_html`.

### v2.0.1
- Correção de falha na geração de GRD no backend.

### v2.0.0
- Integração de avatar do usuário e melhorias de UX no cabeçalho.
- Upload de foto de perfil com `FormData` e proxy de `/uploads`.
